/*
 * Decompiled with CFR 0.152.
 */
package dev.lambdaurora.spruceui.option;

import dev.lambdaurora.spruceui.Position;
import dev.lambdaurora.spruceui.option.SpruceOption;
import dev.lambdaurora.spruceui.tooltip.TooltipData;
import dev.lambdaurora.spruceui.util.SpruceUtil;
import dev.lambdaurora.spruceui.widget.SpruceWidget;
import dev.lambdaurora.spruceui.widget.text.SpruceNamedTextFieldWidget;
import dev.lambdaurora.spruceui.widget.text.SpruceTextFieldWidget;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.class_124;
import net.minecraft.class_2583;
import net.minecraft.class_5481;
import org.jetbrains.annotations.NotNull;

public class SpruceIntegerInputOption
extends SpruceOption {
    private final Supplier<Integer> getter;
    private final Consumer<Integer> setter;

    public SpruceIntegerInputOption(String key, Supplier<Integer> getter, Consumer<Integer> setter, @NotNull TooltipData tooltip) {
        super(key);
        this.getter = getter;
        this.setter = setter;
        this.setTooltip(tooltip);
    }

    @Override
    public SpruceWidget createWidget(Position position, int width) {
        SpruceTextFieldWidget textField = new SpruceTextFieldWidget(position, width, 20, this.getPrefix());
        textField.setText(String.valueOf(this.get()));
        textField.setTextPredicate(SpruceTextFieldWidget.INTEGER_INPUT_PREDICATE);
        textField.setRenderTextProvider((displayedText, offset) -> {
            try {
                Integer.parseInt(textField.getText());
                return class_5481.method_30747((String)displayedText, (class_2583)class_2583.field_24360);
            }
            catch (NumberFormatException e) {
                return class_5481.method_30747((String)displayedText, (class_2583)class_2583.field_24360.method_10977(class_124.field_1061));
            }
        });
        textField.setChangedListener(input -> {
            int value = SpruceUtil.parseIntFromString(input);
            this.set(value);
        });
        this.getTooltip().ifPresent(textField::setTooltip);
        return new SpruceNamedTextFieldWidget(textField);
    }

    public void set(int value) {
        this.setter.accept(value);
    }

    public int get() {
        return this.getter.get();
    }

    public static class Builder
    extends SpruceOption.Builder<Builder, SpruceIntegerInputOption> {
        private final Supplier<Integer> getter;
        private final Consumer<Integer> setter;

        public Builder(String key, Supplier<Integer> getter, Consumer<Integer> setter) {
            super(key);
            this.getter = getter;
            this.setter = setter;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public SpruceIntegerInputOption build() {
            return new SpruceIntegerInputOption(this.key, this.getter, this.setter, this.tooltip);
        }
    }
}

